/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.udp.wifi.set;

import com.gprinter.udp.CommandUDP;
import com.gprinter.udp.Response;
import com.gprinter.udp.wifi.set.ResultResp;

public class SettingApLannCommand
extends CommandUDP {
    private String ip;
    private String mask;

    public SettingApLannCommand(String ip, String mask) {
        this.ip = ip;
        this.mask = mask;
    }

    @Override
    public byte[] getCommand() {
        return this.getAT_LANN(this.ip, this.mask).getBytes();
    }

    @Override
    public Response resolveResponseData(long uuid, byte[] data) {
        try {
            if (data != null) {
                String response = new String(data);
                ResultResp resultResp = new ResultResp();
                if (response.contains("+ok")) {
                    resultResp.setResult(true);
                } else {
                    resultResp.setResult(false);
                }
                return resultResp;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getAT_LANN(String ip, String mask) {
        if (!ip.equals("")) {
            String cmd = "AT+LANN=";
            cmd = cmd + ip;
            cmd = cmd + ",";
            cmd = cmd + mask;
            cmd = cmd + "\r";
            return cmd;
        }
        return "";
    }
}

